# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 6
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR6_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR6(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    # Check if opponent always cooperates or always defects
    always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
    always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
    
    if always_d:
        return "D"
    if always_c:
        if len(my_history) % 3 == 0:
            return "D"
        else:
            return "C"
    
    # Late-game adjustment: defect in last 2 rounds if opponent has defected before
    if len(my_history) >= 8 and any(move == "D" for move in opp_history):
        return "D"
    
    # Tit-for-Tat with forgiveness
    if opp_history[-1] == "D":
        return "D"
    else:
        # Occasionally forgive after mutual defection
        if len(my_history) >= 2 and my_history[-1] == "D" and opp_history[-1] == "D":
            if len(my_history) % 4 == 0:
                return "C"
            else:
                return "D"
        return "C"